#ifndef CAT_H
#define CAT_H

#include <nl_types.h>

#define USAGE catgets(catd,1,1,"Usage: teapot [-a] [-b] [-n] [-r] [-p digits] [file]\n")
#define OHWELL catgets(catd,1,2,"ERROR")
#define DIV0 catgets(catd,1,3,"division by 0")
#define DIVTYPE catgets(catd,1,4,"wrong types for / operator")
#define MOD0 catgets(catd,1,5,"modulo 0")
#define MODTYPE catgets(catd,1,6,"wrong types for % operator")
#define MULTYPE catgets(catd,1,7,"wrong types for * operator")
#define ADDTYPE catgets(catd,1,8,"wrong types for + operator")
#define SUBTYPE catgets(catd,1,9,"wrong types for - operator")
#define NEGTYPE catgets(catd,1,10,"wrong type for - operator")
#define POWTYPE catgets(catd,1,11,"wrong types for ^ operator")
#define MISSOPR catgets(catd,1,12,"missing operator")
#define TOOMANY catgets(catd,1,13,"too many arguments")
#define NESTEVAL catgets(catd,1,14,"nested eval()")
#define CPEXPCT catgets(catd,1,15,") expected")
#define OPEXPECT catgets(catd,1,16,"( expected")
#define VLEXPCT catgets(catd,1,17,"value expected")
#define PARSERR catgets(catd,1,18,"parse error after term")
#define NOINT catgets(catd,1,19,"int(string): invalid string")
#define INFINT catgets(catd,1,20,"int(string): domain error")
#define RELTYPE catgets(catd,1,21,"type mismatch for relational operator")
#define NOLABEL catgets(catd,1,22,"No such label")
#define NEGLOC catgets(catd,1,23,"Negative index")
#define POW00 catgets(catd,1,24,"0^0 is not defined")
#define POWDOM catgets(catd,1,25,"^ caused a domain error")
#define ISLOCKED catgets(catd,1,26,"Cell is locked")
#define NOTAG catgets(catd,1,27,"Unknown tag %c in line %d")
#define MOVEONLY catgets(catd,1,28,"V")
#define MOVEEDIT catgets(catd,1,29,"E")
#define SHADOWBOO2 catgets(catd,1,30,"Trying to shadow cell (%d,%d,%d) in line %d")
#define XERR catgets(catd,1,31,"Parse error for x position in line %d")
#define YERR catgets(catd,1,32,"Parse error for y position in line %d")
#define ZERR catgets(catd,1,33,"Parse error for z position in line %d")
#define OPTERR catgets(catd,1,34,"Invalid option %c in line %d")
#define SYNERR catgets(catd,1,35,"Expression syntax error in line %d")
#define WIDTHERR catgets(catd,1,36,"Parse error for width in line %d")
#define PRECERR catgets(catd,1,37,"Parse error for precision in line %d")
#define ADJERR catgets(catd,1,38,"Parse error for adjustment in line %d")
#define SCFEATURE catgets(catd,1,39,"Unimplemented SC feature in line %d")
#define NOTFINITE catgets(catd,1,40,"Not a (finite) floating point number")
#define UFLOW catgets(catd,1,41,"Floating point range underflow")
#define OFLOW catgets(catd,1,42,"Floating point range overflow")
#define UNCOMPAR catgets(catd,1,43,"uncomparable elements")
#define NOREGION catgets(catd,1,44,"No region selected")
#define SHELL catgets(catd,1,45,"Spawn sub shell")
#define SUBSHELL catgets(catd,1,46,"Sub shell started")
#define BACKGROUND catgets(catd,1,47,"Teapot stopped")
#define NOTSUSPENDED catgets(catd,1,48,"The susp character is undefined")
#define BROKENSHEET catgets(catd,1,49,"Invalid record, loading aborted")
#define WRONGXDRMAGIC catgets(catd,1,50,"This is not a teapot worksheet in XDR format")
#define TRUNCHEADER catgets(catd,1,51,"The record header appears to be truncated")
#define TRUNCBODY catgets(catd,1,52,"The record body appears to be truncated")
#define NOBOF catgets(catd,1,53,"This is not a WK1 file")
#define NOEOF catgets(catd,1,54,"File truncated")
#define INVALIDBODYLEN catgets(catd,1,55,"Invalid record body length")
#define NOMEM catgets(catd,1,56,"Out of memory")
#define YES catgets(catd,1,57,"yY)es")
#define NO catgets(catd,1,58,"nN)o")
#define ADJUST catgets(catd,1,59,"rR)epresentation")
#define ADLEFT catgets(catd,1,60,"lL)eft")
#define ADRIGHT catgets(catd,1,61,"rR)ight")
#define ADCENTERED catgets(catd,1,62,"cC)entered")
#define PRECISION catgets(catd,1,63,"pP)recision")
#define DOLOCK catgets(catd,1,64,"oLo)ck")
#define DOIGNORE catgets(catd,1,65,"iI)gnore")
#define DOSCI catgets(catd,1,66,"00).123e1")
#define NOSCI catgets(catd,1,67,"11).23")
#define LABEL catgets(catd,1,68,"lL)abel")
#define ASXDR catgets(catd,1,69,"xX)DR")
#define ASASCII catgets(catd,1,70,"aA)SCII")
#define ASSC catgets(catd,1,71,"sS)C")
#define ASWK1 catgets(catd,1,72,"wW)K1")
#define TBL catgets(catd,1,73,"tT)bl")
#define LATEX catgets(catd,1,74,"lL)aTeX")
#define HTML catgets(catd,1,75,"hH)TML")
#define CSV catgets(catd,1,76,"cC)SV")
#define GCSV catgets(catd,1,77,"cG)CSV")
#define SAVETEXT catgets(catd,1,78,"fF)ormatted text")
#define CONTEXT catgets(catd,1,79,"oCo)nTeXt")
#define LOAD catgets(catd,1,80,"lL)oad")
#define SAVE catgets(catd,1,81,"sS)ave")
#define NAME catgets(catd,1,82,"nN)ame")
#define FILER catgets(catd,1,83,"fF)ile")
#define QUIT catgets(catd,1,84,"qQ)uit")
#define ATTR catgets(catd,1,85,"aA)ttributes")
#define SHADOW catgets(catd,1,86,"sS)hadow")
#define TRANSPAR catgets(catd,1,87,"oO)utput special characters")
#define INX catgets(catd,1,88,"cC)olumn")
#define INY catgets(catd,1,89,"rR)ow")
#define INZ catgets(catd,1,90,"dD)epth")
#define INSERT catgets(catd,1,91,"iI)nsert")
#define CLEAR catgets(catd,1,92,"ecle)ar")
#define MOVE catgets(catd,1,93,"mM)ove")
#define COPY catgets(catd,1,94,"cC)opy")
#define FILL catgets(catd,1,95,"fF)ill")
#define MIRROR catgets(catd,1,96,"rMir)ror")
#define TOMENU catgets(catd,1,97,"Use F0, F10 or / for menu")
#define ABOUT catgets(catd,1,98,"vV)ersion")
#define MSHELL catgets(catd,1,99,"sS)hell")
#define MGOTO catgets(catd,1,100,"gG)oto")
#define CWIDTH catgets(catd,1,101,"wW)idth")
#define DELETE catgets(catd,1,102,"dD)elete")
#define SORT catgets(catd,1,103,"sS)ort")
#define ADDKEY catgets(catd,1,104,"aA)dd key")
#define ASCEND catgets(catd,1,105,"aA)scending")
#define DESCEND catgets(catd,1,106,"dD)escending")
#define SORTIT catgets(catd,1,107,"sS)ort region")
#define WHOLECOL catgets(catd,1,108,"wW)hole column")
#define WHOLELINE catgets(catd,1,109,"wW)hole line")
#define WHOLELAYER catgets(catd,1,110,"wW)hole sheet")
#define SINGLECELL catgets(catd,1,111,"sS)ingle cell")
#define BLOCK catgets(catd,1,112,"bB)lock")
#define LOADXSHEET catgets(catd,1,113,"Load sheet from XDR file:")
#define LOADPSHEET catgets(catd,1,114,"Load sheet from ASCII file:")
#define LOADCSVSHEET catgets(catd,1,115,"Load sheet from CSV file:")
#define LOADSCSHEET catgets(catd,1,116,"Load sheet from SC file:")
#define LOADWK1SHEET catgets(catd,1,117,"Load sheet from WK1 file:")
#define SAVEXSHEET catgets(catd,1,118,"Save sheet to XDR file:")
#define WROTECELLS catgets(catd,1,119,"%u cells written")
#define SAVEPSHEET catgets(catd,1,120,"Save sheet to ASCII file:")
#define SAVEMENU catgets(catd,1,121,"Save sheet file format:")
#define LOADMENU catgets(catd,1,122,"Load sheet file format:")
#define NAMESHEET catgets(catd,1,123,"New file name:")
#define FILERMENU catgets(catd,1,124,"File:")
#define LOADANYWAY catgets(catd,1,125,"Sheet modified, load new file anyway?")
#define LEAVE catgets(catd,1,126,"Sheet modified, leave anyway?")
#define MAINMENU catgets(catd,1,127,"Main menu:")
#define COLWIDTH catgets(catd,1,128,"Column width:")
#define CELLATTR catgets(catd,1,129,"Cell attribute:")
#define SHADOWCELL catgets(catd,1,130,"Shadow cell:")
#define TRANSCELL catgets(catd,1,131,"Make cell transparent:")
#define TRANSCUBE catgets(catd,1,132,"Make block transparent:")
#define CONTENTS catgets(catd,1,133,"Cell contents:")
#define CCONTENTS catgets(catd,1,134,"Clocked cell contents:")
#define GOTO catgets(catd,1,135,"Go to location:")
#define LOCBOO catgets(catd,1,136,"Not a valid location")
#define SHADOWBOO catgets(catd,1,137,"You can not shadow cells in column 0")
#define WHAT catgets(catd,1,138,"Unknown batch command:")
#define PRECCELL catgets(catd,1,139,"Precision for cell:")
#define PRECBLOCK catgets(catd,1,140,"Precision for block:")
#define SAVETEXTF catgets(catd,1,141,"Save in plain text format to file:")
#define SAVECSVF catgets(catd,1,142,"Save in CSV format to file:")
#define SAVETBLF catgets(catd,1,143,"Save in tbl format to file:")
#define SAVELATEXF catgets(catd,1,144,"Save in LaTeX format to file:")
#define SAVEHTMLF catgets(catd,1,145,"Save in HTML format to file:")
#define SAVECONTEXTF catgets(catd,1,146,"Save in ConTeXt format to file:")
#define BLOCKATTR catgets(catd,1,147,"Block attribute:")
#define CLEARBLOCK catgets(catd,1,148,"Clear block:")
#define CLEARCELL catgets(catd,1,149,"Clear cell:")
#define SHADOWCUBE catgets(catd,1,150,"Shadow block:")
#define INSERTBLOCK catgets(catd,1,151,"Insert:")
#define DELETEBLOCK catgets(catd,1,152,"Delete:")
#define MODIFYCELL catgets(catd,1,153,"Edit cell:")
#define LOCKCELL catgets(catd,1,154,"Lock cell:")
#define LOCKBLOCK catgets(catd,1,155,"Lock block:")
#define IGNCELL catgets(catd,1,156,"Ignore cell value:")
#define IGNBLOCK catgets(catd,1,157,"Ignore values of all cells in this block:")
#define DOLABEL catgets(catd,1,158,"Cell label:")
#define MOVEBLOCK catgets(catd,1,159,"Move block:")
#define NOMARK catgets(catd,1,160,"No block marked")
#define COPYBLOCK catgets(catd,1,161,"Copy block:")
#define FILLBLOCK catgets(catd,1,162,"Fill block:")
#define FILLCOLS catgets(catd,1,163,"Number of column-wise repetitions:")
#define FILLROWS catgets(catd,1,164,"Number of row-wise repetitions:")
#define FILLLAYERS catgets(catd,1,165,"Number of depth-wise repetitions:")
#define SORTBLOCK catgets(catd,1,166,"Sort block:")
#define XPOS catgets(catd,1,167,"X position of key vector:")
#define YPOS catgets(catd,1,168,"Y position of key vector:")
#define ZPOS catgets(catd,1,169,"Z position of key vector:")
#define MIRRORBLOCK catgets(catd,1,170,"Mirror block:")
#define LEFTRIGHT catgets(catd,1,171,"lL)eft-right")
#define UPSIDEDOWN catgets(catd,1,172,"uU)pside-down")
#define FRONTBACK catgets(catd,1,173,"fF)ront-back")
#define STANDALONE catgets(catd,1,174,"Save as stand-alone document:")
#define BLOCKMENU catgets(catd,1,175,"Block menu:")
#define NOSHADOW catgets(catd,1,176,"Shadowed cells in first column")
#define INVALPRECISION catgets(catd,1,177,"teapot: precision must be between 0 and %d.\n")
#define USAGE_ERROR catgets(catd,1,178,"Usage: error(string message)")
#define USAGE_ADR catgets(catd,1,179,"Usage: &([integer x][,[integer y][,[integer z]]])")
#define USAGE_AT catgets(catd,1,180,"Usage: @([integer x][,[integer y][,[integer z]]]) or @(location)")
#define XTYPE catgets(catd,1,181,"Usage: x([location])")
#define YTYPE catgets(catd,1,182,"Usage: y([location])")
#define ZTYPE catgets(catd,1,183,"Usage: z([location])")
#define STRINGTYPE catgets(catd,1,184,"Usage: string(location) or string(float[,[integer][,integer]])")
#define SUMTYPE catgets(catd,1,185,"Usage: sum(location,location)")
#define NTYPE catgets(catd,1,186,"Usage: n(location,location)")
#define INTTYPE catgets(catd,1,187,"Usage: int(float[,integer,integer])")
#define FRACTYPE catgets(catd,1,188,"Usage: frac(float)")
#define LENTYPE catgets(catd,1,189,"Usage: len(string)")
#define MINTYPE catgets(catd,1,190,"Usage: min(location,location)")
#define MAXTYPE catgets(catd,1,191,"Usage: max(location,location)")
#define ABSTYPE catgets(catd,1,192,"Usage: abs(float|integer)")
#define USAGE_EVAL catgets(catd,1,193,"Usage: eval(location)")
#define USAGE_ENV catgets(catd,1,194,"Usage: $(string)")
#define FLOATTYPE catgets(catd,1,195,"Usage: float(string)")
#define STRFTIMETYPE catgets(catd,1,196,"Usage: strftime(string[,integer])")
#define CLOCK catgets(catd,1,197,"Usage: clock(condition,location[,location])")
#define POLYTYPE catgets(catd,1,198,"Usage: poly(float|integer,float|integer,...)")
#define ETYPE catgets(catd,1,199,"Usage: e()")
#define LOGTYPE catgets(catd,1,200,"Usage: log(float[,float])")
#define WRONGTYPE catgets(catd,1,201,"Usage: %s(float)")
#define USAGE_RND catgets(catd,1,202,"Usage: rnd()")
#define USAGE_SUBSTR catgets(catd,1,203,"Usage: substr(string,integer,integer)")
#define STRPTIMETYPE catgets(catd,1,204,"Usage: strptime(string,string)")
#define USAGE_TIME catgets(catd,1,205,"Usage: time()")

#endif
